unit TBXDTMForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActnList, StdCtrls, TBX, TBXThemes;

type
  TThemeRefreshEvent = Procedure(Sender:TObject; ThemeList:TStrings) of object;
  TThemeLoadEvent = Procedure(Sender:TObject; ThemeFiles:TStrings) of object;
  TThemeUnloadEvent = Procedure(Sender:TObject; ThemeIndex: Integer) of object;
  TThemeActivateEvent = procedure (Sender:TObject; ThemeIndex:integer) of object;

  TfrmTBXDTM = class(TForm)
    ListBox1: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button4: TButton;
    ActionList1: TActionList;
    actadd: TAction;
    actremove: TAction;
    actActivate: TAction;
    Button3: TButton;
    OpenDialog1: TOpenDialog;
    Button5: TButton;
    procedure actremoveUpdate(Sender: TObject);
    procedure actaddExecute(Sender: TObject);
    procedure actActivateUpdate(Sender: TObject);
    procedure actremoveExecute(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure actActivateExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
  private
    fOnLoad: TThemeLoadEvent;
    fOnRefresh: TThemeRefreshEvent;
    fOnUnload: TThemeUnloadEvent;
    fOnActivate: TThemeActivateEvent;
    { Private declarations }
    procedure RefreshThemeList;
    procedure LoadNewTheme;
    procedure UnloadTheme;
    procedure RefreshCurrentTheme;
    procedure ActivateTheme;
  public
    { Public declarations }
    property OnRefreshThemes:TThemeRefreshEvent read fOnRefresh write fOnRefresh;
    property OnLoadNewTheme:TThemeLoadEvent read fOnLoad write fOnLoad;
    property OnUnloadTheme:TThemeUnloadEvent read fOnUnload write fOnUnload;
    property OnActivateTheme:TThemeActivateEvent read fOnActivate write fOnActivate;
  end;

var
  frmTBXDTM: TfrmTBXDTM;

implementation

{$R *.dfm}

procedure TfrmTBXDTM.actremoveUpdate(Sender: TObject);
begin
   actremove.enabled := (listbox1.ItemIndex > -1) and (listbox1.Items[ListBox1.ItemIndex] <> CurrentTheme.Name);
end;

procedure TfrmTBXDTM.actaddExecute(Sender: TObject);
begin
   LoadNewTheme;
   RefreshThemeList;
   RefreshCurrentTheme;
end;

procedure TfrmTBXDTM.RefreshThemeList;
begin
   ListBox1.Items.BeginUpdate;
   try
      if assigned(fOnRefresh) then
         fOnRefresh(self, ListBox1.Items);
   finally
      listbox1.items.EndUpdate;
   end;
end;

procedure TfrmTBXDTM.actActivateUpdate(Sender: TObject);
begin
    actactivate.enabled := (ListBox1.ItemIndex > -1) and (listbox1.Items[ListBox1.ItemIndex] <> CurrentTheme.Name);
end;

procedure TfrmTBXDTM.LoadNewTheme;
begin
   if OpenDialog1.Execute then
   begin
      if assigned(fOnLoad) then
      begin
         fOnLoad(self, opendialog1.Files);
         RefreshThemeList;
      end;
   end;
end;

procedure TfrmTBXDTM.UnloadTheme;
begin
   if assigned(fOnLoad) then
   begin
      fOnUnload(self, listbox1.itemindex);
      RefreshThemeList;
   end;
end;


procedure TfrmTBXDTM.actremoveExecute(Sender: TObject);
begin
   UnloadTheme;
end;

procedure TfrmTBXDTM.Button5Click(Sender: TObject);
begin
   listbox1.ItemIndex := -1;
   ActivateTheme;
end;

procedure TfrmTBXDTM.actActivateExecute(Sender: TObject);
begin
   ActivateTheme;
end;

procedure TfrmTBXDTM.RefreshCurrentTheme;
begin
   label3.Caption := CurrentTheme.Name;
end;

procedure TfrmTBXDTM.FormActivate(Sender: TObject);
begin
   RefreshThemeList;
   RefreshCurrentTheme;
end;

procedure TfrmTBXDTM.ListBox1DblClick(Sender: TObject);
begin
   if listbox1.ItemIndex <> -1 then
      ActivateTheme;
end;

procedure TfrmTBXDTM.ActivateTheme;
begin
  if assigned(fOnActivate) then
  begin
     fOnActivate(self, ListBox1.ItemIndex);
     RefreshCurrentTheme;
  end;
end;

end.
